// CtrlCard.cpp: implementation of the CCtrlCard class.
//
////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "DEMO.h"
#include "CtrlCard.h"
#include "adt856.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

////////////////////////////////////////////////////////////////////
// Construction/Destruction
////////////////////////////////////////////////////////////////////

CCtrlCard::CCtrlCard()
{

}
/***********************initial motion-card**************************
this function is boot of using motion-card
Return<=0 fail to initial motion-card
Return>0  Succeed in initial motion-card
***********************************************************/
int CCtrlCard::Init_Board()
{
	Result = adt856_initial() ;         //intiial motion-card  
	
	if (Result <= 0) return Result;	
    
    for (int i = 1; i<=MAXAXIS; i++)
	{
		
		set_range (0, i, 8000000 / 5);         //set range,set ratio as 5
		
		set_command_pos (0, i, 0);        //set logic pos as 0
		
		set_actual_pos (0, i, 0);         //set real pos as 0
		
		set_startv (0, i, 100);          //set start-speed
		
		set_speed (0, i, 100);           //set motion-speed

       	set_acc (0, i, 625);              //set acceleration
		
    }
    
    return 1;
	
}


/********************************************
 release of ADT8948 source occupied
***********************************************************/

int CCtrlCard::End_Board ()
{
	Result = adt856_end();
	
	return Result;
}


/********************set stop0 mode**********************

  Set mode of stop0 input signal
  
	para axisaxis number
	value   0ineffective  1effective
		  logic   0low level effective  1high level effective
		  Defaule : ineffective
		  
			Return	0Correct					1 Wrong
  *********************************************************/
int CCtrlCard::Setup_Stop0Mode(int axis, int value, int logic)
{
	Result = set_stop0_mode(0, axis, value ,logic);

	return Result;

}


/********************set stop1 mode**********************

  Set mode of stop1 input signal
  
	para axisaxis number
	value   0ineffective  1effective
		  logic   0low level effective  1high level effective
		  Defaule : ineffective
		  
			Return	0Correct					1 Wrong
  *********************************************************/
int CCtrlCard::Setup_Stop1Mode(int axis, int value, int logic)
{
	Result = set_stop1_mode(0, axis, value, logic);

	return Result;

}

/********************set stop2 mode**********************
	Set mode of stop2 input signal
		  para axisaxis number
	  value   0ineffective  1effective
	  logic   0low level effective  1high level effective
	  Defaule : ineffective
	  
		Return	0Correct					1 Wrong
*********************************************************/
int CCtrlCard::Setup_Stop2Mode(int axis, int value, int logic)
{
	Result = set_stop2_mode(0, axis, value, logic);

	return Result;

}
/*********************set real position counter********************
cardno	   Card number
axis	   Axis number1-4
value	   Input of pulse pattern
0        A/B pulse input	1up/downPPIN/PMINpulse input
dir		   Counter direction
0	      A is over B or PPIN impulse input is up counted.
B is over A or PMIN impulse is down counted
1       B is over A or PPIN impulse input is up counted
A is over B or PMIN impulse is down counted.
freq	  During double frequency of A/B input up/down impulse input is non-effective
04-time frequency     12-time frequency        2No-time frequency
Returning value: 0: Correct    1: False
Initialized status: During A/B phase impulse input direction is of 0 and 4-time frequency.
***********************************************************/
int CCtrlCard::Actualcount_Mode(int axis,int value, int dir,int freq)
{

	Result = set_actualcount_mode(0, axis, value,dir,freq);
	
	return Result;
}

/********************set pulse output mode***********************
 set the mode of pulse output
 paraaxis-axis number value-pulse mode 0pulse+pulse 1pulse + direction	
 Return=0 correctReturn=1 wrong
 Default mode: Pulse + direction, with positive logic pulse 
 and positive logic direction input signal		  
***********************************************************/
int CCtrlCard::Setup_PulseMode(int axis, int value)
{
	Result = set_pulse_mode(0, axis, value, 0, 0);
	
	return Result;	

}

/*********************set limit signal mode**********************

  set the mode of nLMT signal input along positive/ negative direction
  para axisaxis number
  value   0: sudden stop effective      1: decelerate stop effective
  logic    0: low level effective	    	1: high level ineffective
  Default mode: Apply positive and negative limits with low level 
  Return	0Correct					1 Wrong
***********************************************************/
int CCtrlCard::Setup_LimitMode(int axis, int value, int logic)
{
	Result = set_limit_mode(0, axis, value,  logic);

	return Result;

}

/******************set COMP+counter as soft limit****************
cardno	    card number
axis		axis number1-4
value		0ineffective				1effective
Return	    0Correct				1Wrong
Default modeineffective
NoticeSoftware position limiting always adopts acceleration to stop. 
Calculating value may be over set up value. Within setup sphere it must be considered.
***********************************************************/
int CCtrlCard::Setsoft_LimitMode1(int axis, int value)
{
    Result =  set_softlimit_mode1(0, axis, value);

	return Result;

}

/******************set COMP-counter as soft limit****************
cardno	    card number
axis		axis number1-4
value		0ineffective				1effective
Return	    0Correct				1Wrong
Default modeineffective
NoticeSoftware position limiting always adopts acceleration to stop. 
Calculating value may be over set up value. Within setup sphere it must be considered.
***********************************************************/
int CCtrlCard::Setsoft_LimitMode2(int axis, int value)
{
    Result =  set_softlimit_mode2(0, axis, value);

	return Result;

}

/****************set COMP+/-counter****************
cardno	    card number
axis		axis number1-4
value		0logic position counter		1real position counter
Return	    0Correct				1Wrong
Default mode : logic position counter
This function is of comparative object for setup of software limiting position.
***********************************************************/
int CCtrlCard::Setsoft_LimitMode3(int axis, int value)
{
    Result =  set_softlimit_mode3(0, axis, value);

	return Result;

}

/****************Set n-INPOS of servo-on signal*******************
cardno	    card number
axis		axis number1-4
value		0ineffective				1effective
logic		0Effective when low electric level		1Effective when low electric level
Return	    0Correct				1Wrong
Default mode :  Non-effective, low electric level is effective
***********************************************************/

int CCtrlCard::Inpos_Mode(int axis, int value, int logic)
{
	Result = set_inpos_mode(0, axis,value,logic);
	
	return Result;
}

/****************Set n-ALARM of servo-on signal*******************
cardno	    card number
axis		axis number1-4
value		0ineffective			1effective
logic		0Effective when low electric level	1Effective when low electric level
Return	    0Correct				1Wrong
Default mode :  Non-effective, low electric level is effective
***********************************************************/

int CCtrlCard:: Setup_AlarmMode(int axis,int value,int logic)
{
	Result = set_alarm_mode(0, axis,value,logic);
	
	return Result;
}


/************************set speed***********************
according as para,judge whether is constant-speed
set range to set ratio
set start-speed ,motion-speed and acceleration
paraaxis:   axis number
startv: start-speed
speed:  motion-speed
add:    acceleration
dec:    decelerate
ratio:  ratio
mode:   mode    
Return=0 correctReturn=1 wrong
***********************************************************/
int CCtrlCard::Setup_Speed(int axis, long startv, long speed, long add ,long dec,long ratio,int mode)
{
	//constant-speed motion
	if (startv - speed >= 0) 
	{
		Result = set_range(0, axis, 8000000/ratio);
		
		set_startv(0, axis, startv/ratio);
		
		set_speed (0, axis, startv/ratio);
	}
	else//Trapezoidal acceleration/ deceleration
	{
		if (mode == 0)//choose Strait line acceleration/deceleration type
		{
            set_dec1_mode(0,axis,0);//Set symmetry type
			
			set_dec2_mode(0,axis,0);//Set automatic deceleration

            set_ad_mode(0,axis,0);//Set as Strait acceleration/deceleration
			
			Result = set_range(0, axis, 8000000/ratio);
			
			set_startv(0, axis, startv/ratio);
			
			set_speed (0, axis, speed/ratio);
			
			set_acc (0, axis, add/125/ratio);
					
			
		}
		else if(mode==1)//choose Strait line acceleration/deceleration type
		{
			
			set_dec1_mode(0,axis,1);//asymmetry 
			
			set_dec2_mode(0,axis,0);//Set automatic deceleration

		    set_ad_mode(0,axis,0);//Set as Strait acceleration/deceleration	

			Result = set_range(0, axis, 8000000/ratio);
			
			set_startv(0, axis, startv/ratio);
			
			set_speed (0, axis, speed/ratio);
			
			set_acc (0, axis, add/125/ratio);
			
			set_dec (0, axis, dec/125/ratio);
						
		
		}
		else if(mode==2)
		{//choose S-curve acceleration/deceleration type
			float time;//time

			float addvar;//changing rate of add

			long k;

            time = (float)(speed-startv)/(add/2);

			addvar=add/(time/2);;//changing rate of add

			k=(long)(62500000/addvar)*ratio;

            set_dec2_mode(0,axis,0);//automatic deceleration

            set_ad_mode(0,axis,1);//as Strait acceleration/deceleration

			Result = set_range(0, axis, 8000000/ratio);
			
			set_startv(0, axis, startv/ratio);
			
			set_speed (0, axis, speed/ratio);
			
			set_acc (0, axis, add/125/ratio);
			
			set_acac (0, axis,k );					
			
		}		
		
	}
	
	return Result;
	
}


/************************single-axis motion***********************

  drive one axis motion
  
    para axis-axis numbervalue-pulse of motion
    
	  Return=0 correctReturn=1 wrong
***********************************************************/
int CCtrlCard::Axis_Pmove(int axis, long value)
{
	Result = pmove(0, axis, value);
	
	return Result;

}


/************************single-axis continuous motion***********************

  drive one axis motion
  
    para axis-axis numbervalue-pulse of motion
    
	  Return=0 correctReturn=1 wrong
***********************************************************/
int CCtrlCard::Axis_Cmove(int axis, long value)
{
	Result = continue_move(0, axis, value);
	
	return Result;

}


/**********************2-axis interpolation*********************

  for XY or ZW 2-axis linear interpolation
	 no ->   1: X-Y       2:Z-W
	 
	   Return=0 correctReturn=1 wrong
	   
***********************************************************/
int CCtrlCard::Interp_Move2(int no, long value1, long value2)
{
	Result = inp_move2(0, no, value1, value2);

	return Result;

}


/*********************3-axis interpolation**********************

  for XYZ 3-axis linear interpolation
  
    Return=0 correctReturn=1 wrong
	
***********************************************************/
int CCtrlCard::Interp_Move3(long value1, long value2, long value3)
{
	Result = inp_move3(0, value1, value2, value3);

	return Result;

}

/*********************4-axis interpolation**********************

  for XYZW 4-axis linear interpolation
  
    Return=0 correctReturn=1 wrong
	
***********************************************************/

int CCtrlCard::Interp_Move4(long value1, long value2, long value3, long value4)
{
	Result = inp_move4(0, value1, value2, value3, value4);

	return Result;

}

/*********************6-axis interpolation**********************

  for XYZWUV 6-axis linear interpolation
  
    Return=0 correctReturn=1 wrong
	
***********************************************************/
int CCtrlCard::Interp_Move6(long value1, long value2, long value3, long value4, long value5, long value6)
{
	Result = inp_move6(0, value1, value2, value3, value4,value5, value6);

	return Result;

}

/**********************Clockwise CW circular interpolation*****************

 axis1,axis2    1X   2:Y   3Z  4:W

 x,y		Terminal position of Arc SR (corresponding to starting point)
				
 i,j		Central point position of SR circle arc (corresponding to starting point)

            The function enable XY-axis and ZW-axis do circular interpolation
    
return      0Correct	   1False

***********************************************************/
int CCtrlCard::Interp_Arc(int no, long x, long y, long i,long j)
{
	Result = inp_cw_arc(0,no,x,y,i,j);

	return Result;
}


/**********************Clock against CCW circular interpolation****************
axis1,axis2    	1X    2Y    3Z   4W
x,y		        Terminal position of Arc SR (corresponding to starting point)
i,j		        Central point position of SR circle arc (Corresponding to starting point)
                The function enable any axis do circular interpolation
return      0Correct	   1False
***********************************************************/
int CCtrlCard::Interp_CcwArc(int no, long x, long y, long i,long j)
{
	Result = inp_ccw_arc(0,no,x,y,i,j);

	return Result;
}


/*****************position counter variable ring******************
      the variable ring function enables the setting of any value as the maximum value.
	  This function is useful for managing the position of the axis in circular motions 
	  that return to the home position after one rotation,rather than linear motions
***********************************************************/
int CCtrlCard::SetCircle_Mode(int axis, int value)
{
	Result = set_circle_mode(0,  axis, value);
	
	return Result;
}


/********************Setup of signal wave filtering function*******************

value	0Wave filter is ineffective     1: Wave filter is effective.

Initialized status: ineffective

***********************************************************/
int CCtrlCard::Setup_InputFilter(int axis,int number,int value)
{
	
	Result = set_input_filter(0, axis, number, value);

	return Result;
}


/***********setup of wave filter time constant of input signal****************
axis	   axis number(1-4)

value      maximum noise scope deleted ,   delay of input signal
***********************************************************/
int CCtrlCard::Setup_FilterTime(int axis,int value)
{
	
	Result = set_filter_time(0, axis, value);
	
	return Result;
}


/*****************get status of motion**************************

    get status of single-axis motion or interpolation

    paraaxis-axis numbervalue-Indicator of motion status(0Drive completed,Non-0: Drive in process)
	  
		  mode(0-single-axis motion1interpolation)
    
    Return=0 correctReturn=1 wrong

***********************************************************/
int CCtrlCard::Get_CurrentInf(int axis, long &LogPos, long &ActPos, long &Speed)
{
	Result = get_command_pos(0, axis, &LogPos);
    
    get_actual_pos (0, axis, &ActPos);
    
    get_speed (0, axis, &Speed);

	return Result;
}

/*****************stop motion********************************

  stop motion in the way of sudden or decelerate
  
	paraaxis-axis numbermode-stop mode(0sudden stop, 1decelerate stop)
    
	  Return=0 correctReturn=1 wrong
	  
***********************************************************/
int CCtrlCard::StopRun(int axis, int mode)
{
	if(mode == 0)       //ֹͣ
    {
        Result = sudden_stop(0, axis);
	}   
    else                 //ֹͣ
    {
        Result = dec_stop(0, axis);
	}   
    return Result;
	
}



/*****************get status of motion**************************

  get status of single-axis motion or interpolation
  
    paraaxis-axis numbervalue-Indicator of motion status(0Drive completed,Non-0: Drive in process)
	
	  mode(0-single-axis motion1interpolation)
	  
		Return=0 correctReturn=1 wrong
		
***********************************************************/
int CCtrlCard::Get_Status(int axis, int &value, int mode)
{


	if (mode==0)         //status of single-axis motion

		Result=get_status(0,axis,&value);

	else                  //status of interpolation

		Result=get_inp_status(0,axis,&value);

	return Result;

}


/*****************************deceleration enable**************************

  no		1X-Y or X-Y-Z or X-Y-Z-W interpolation	2Z-W interpolation
  
	the function allowable deceleration during driving
	
	  retutrn         0correct          1wrong
	  
*******************************************************************/

int CCtrlCard::AllowDec(int no)
{
      Result=inp_dec_enable(0,no);

	  return Result;
}


/**************************deceleration disable******************************

  no		1X-Y or X-Y-Z or X-Y-Z-W interpolation 	2Z-W interpolation
  
	the function for deceleration disable during driving
	
	  retutrn         0correct          1wrong
	  
********************************************************************/
int CCtrlCard::ForbidDec(int no)
{
	Result=inp_dec_disable(0,no);

	return Result;

}


/****************getting information about mistaken stop on all axes******************
This function is  for getting information about the axis stop

  value:     error message  0no error  1error
  
	retutrn         0correct          1wrong
	
*********************************************************************/
int CCtrlCard::Get_ErrorInf(int axis, int &value)
{
	Result=get_stopdata(0,axis,&value);

	return Result;
}


/*******get the status of continuous interpolation*****************

  value  inter-infor  0write disable 1write able
  
	retutrn         0correct          1wrong
	
********************************************************************/
int CCtrlCard::Get_AllowInpStatus(int no, int &value)
{
	Result=get_inp_status2(0,no,&value);

	return Result;
}


/***********************set deceleration type**********************
deceleration for symmetry/asymmetry/automatic/manual

  retutrn         0correct          1wrong
*********************************************************************/
int CCtrlCard::Set_DecMode(int axis, int mode1, int mode2)
{   
	int result1,result2;

	result1=set_dec1_mode(0,axis,mode1);

	result2=set_dec2_mode(0,axis,mode2);

	Result=result1 && result2;

	return Result;
}


/***********************set deceleration point****************************
set deceleration point during manual deceleration

  retutrn         0correct          1wrong
*********************************************************************/
int CCtrlCard::Set_DecPos(int axis, long value, long startv, long speed, long add)
{
	float addtime;

	long  DecPulse;   //the pulse for deceleration
	
	addtime=float(speed-startv)/add;

	DecPulse=long((startv+speed)*addtime)/2;

	Result=set_dec_pos(0,axis,value-DecPulse);

    return Result;
}


/****************************read input*******************************

  read status of input
  
	paranumber-input port(0 ~ 31)
	
	  Return0  low level1  high level-1  error
*********************************************************************/
int CCtrlCard::Setup_Range(int axis, long value)
{
	Result=set_range(0,axis,value);
	
	return Result;
}



/****************************read input*******************************

  read status of input
  
	paranumber-input port(0 ~ 47)
	
	  Return0  low level1  high level-1  error
*********************************************************************/
int CCtrlCard::Read_Input(int number)
{
	Result = read_bit(0, number);
    
	return Result;
}


/***************************output******************************

  set status 0f output
  
    para number-output port(0 ~ 31),value 0-low level1high level
	
	  Return=0 correctReturn=1 wrong
**********************************************************************/

int CCtrlCard::Write_Output(int number, int value)
{
	Result = write_bit(0, number, value);

	return Result;

}

/*************************set position counter*******************************

  set logic-pos or  real-pos
  
	paraaxis-axis number,pos-the set value 
	mode 0set logic pos,non 0set real pos
	
      Return=0 correctReturn=1 wrong
**********************************************************************/
	 
int CCtrlCard::Setup_Pos(int axis, long pos, int mode)
{
	if(mode==0)
	{
		Result = set_command_pos(0, axis, pos);
	}
	else
	{
		Result = set_actual_pos(0, axis, pos);
	}
	
	return Result;
	
}


/*************************set COMP+ register******************************
cardno	 card number
axis		 axis number
value	     range-2147483648~+2147483647
retutrn         0correct          1wrong
**********************************************************************/
int CCtrlCard::Setup_Comp1(int axis, long value)
{
	Result= set_comp1(0, axis, value);

    return Result;
}


/**************************set COMP- register*****************************

  cardno	 card number
  axis		 axis number
  value	     range-2147483648~+2147483647
  retutrn         0correct          1wrong
  
**********************************************************************/
int CCtrlCard::Setup_Comp2(int axis, long value)
{
	Result= set_comp2(0, axis, value);
	
    return Result;
}



